<?php

namespace Vtlabs\Event\Models;

use EloquentFilter\Filterable;
use Vtlabs\Event\Models\Partner;
use Spatie\MediaLibrary\HasMedia;
use Vtlabs\Core\Models\User\User;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Vtlabs\Core\Traits\CoreHasMediaTrait;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Coupon extends Model implements HasMedia
{
    use Filterable,
        HasTranslations,
        CoreHasMediaTrait;

    protected $table = 'ev_coupons';

    protected $guarded = [];

    protected $appends = ['mediaurls'];

    protected $casts = [
        'title' => 'array',
        'description' => 'array',
        'terms' => 'array',
        'meta' => 'json',
        'usage' => 'integer',
        'condition_value' => 'float',
        'reward' => 'float',
        'expires_at' => 'date:Y-m-d'
    ];

    public $translatable = ['title', 'description', 'terms'];

    public function partner(): BelongsTo
    {
        return $this->belongsTo(Partner::class);
    }

    public function users(): BelongsToMany
    {
        return $this->belongsToMany(User::class, 'ev_coupons_users');
    }

    public function isUsed(int $userId)
    {
        $usageCount = $this->users()->wherePivot('user_id', $userId)->count();
        $isUsed = true;

        if (($this->usage == 0 || $usageCount < $this->usage)) {
            $isUsed = false;
        }

        return $isUsed;
    }

    public function canRedeem(int $userId, float $billAmount)
    {
        if($this->isUsed($userId)) {
            return [false, 'Already redeemed'];
        }
        if($this->condition_type == 'minimum' && floatval($billAmount) < floatval($this->condition_value)) {
            return [false, 'Unable to redeem the coupon. Minium required not met'];
        }

        if($this->condition_type == 'exact' && floatval($billAmount) == floatval($this->condition_value)) {
            return [false, 'Unable to redeem the coupon. Minium required not met'];
        }

        return [true, 'success'];
    }
}
