<?php

namespace Vtlabs\Event\Listeners;

use Rennokki\Plans\Models\PlanModel;
use Vtlabs\Media\Models\Media;
use Vtlabs\Core\Models\User\User;
use Vtlabs\Event\Models\EventOrder;
use Vtlabs\Payment\Events\OnWalletPayment;
use Vtlabs\Media\Http\Resources\Media\MediaOrderResource;

class OnWalletPaymentListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  OnWalletPayment $event
     * @return void
     */
    public function handle(OnWalletPayment $event)
    {
        $payment = $event->payment;

        if ($payment->payable_type == PlanModel::class && $payment->status == 'paid') {
            $plan = PlanModel::find($payment->payable_id);
            $user = User::find($payment->payer_id);

            $user->withdraw($payment->amount, 'withdraw', [
                'description' => 'Paid for plan #' . $plan->id,
                'type' => 'wallet_payment'
            ]);
        }

        if ($payment->payable_type == EventOrder::class && $payment->status == 'paid') {
            $order = EventOrder::find($payment->payable_id);
            $user = User::find($payment->payer_id);

            $user->withdraw($payment->amount, 'withdraw', [
                'description' => 'Paid for event ' . $order->event->title,
                'type' => 'wallet_payment'
            ]);
        }
    }
}
