<?php

namespace Vtlabs\Event\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class SeatResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'title_translations' => $this->getTranslations('title'),
            'row' => $this->row,
            'column' => $this->column,
            'type' => $this->type,
            'meta' => $this->meta,
            'auditorium_id' => $this->auditorium_id,
            'category_id' => $this->category_id,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'is_booked' => $this->is_booked ?? false
        ];
    }
}
