<?php

namespace Vtlabs\Event\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class PartnerResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'title_translations' => $this->getTranslations('title'),
            'description' => $this->description,
            'description_translations' => $this->getTranslations('description'),
            'meta' => $this->meta,
            'mediaurls' => $this->getMediaUrlsAttribute(),
            'coupons' => CouponResource::collection($this->coupons),
            'area' => $this->area,
            'address' => $this->address,
            'longitude' => $this->longitude,
            'latitude' => $this->latitude,
            'distance' => $this->distance ?? "0.00",
        ];
    }
}
