<?php

namespace Vtlabs\Event\Http\Resources;

use Vtlabs\Core\Http\Resources\UserResource;
use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Event\Http\Resources\FeatureResource;

class FeatureresponseResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'feature_id' => $this->feature_id,
            'feature' => new FeatureResource($this->feature),
            'user_id' => $this->user_id,
            'user' => new UserResource($this->user),
            'meta' => $this->meta,
            'created_at' => $this->created_at->format('Y-m-d')
        ];
    }
}
