<?php

namespace Vtlabs\Event\Http\Resources;

use Vtlabs\Core\Http\Resources\UserResource;
use Vtlabs\Event\Http\Resources\SeatResource;
use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Payment\Http\Resources\PaymentResource;
use Vtlabs\Event\Http\Resources\EventOrderSeatResource;

class EventOrderResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'meta' => $this->meta,

            'subtotal' => $this->subtotal,
            'taxes' => $this->taxes,
            'total' => $this->total,
            'discount' => $this->discount,
            
            'event_id' => $this->event_id,
            'event' => new EventResource($this->event),
            
            'user_id' => $this->user_id,
            'user' => new UserResource($this->user),

            'payment' => new PaymentResource($this->payment),

            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,

            'seats' => SeatResource::collection($this->seats),
            'seats_count' => $this->seats()->count()
        ];
    }
}
