<?php

namespace Vtlabs\Event\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class EventArtistResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'event_id' => $this->pivot->event_id,
            'artist_id' => $this->pivot->artist_id,
            'artist' => new ArtistResource($this),
            'time_from' => $this->pivot->time_from,
            'time_to' => $this->pivot->time_to,
        ];
    }
}
