<?php

namespace Vtlabs\Event\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class CouponResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'title_translations' => $this->getTranslations('title'),
            'description' => $this->description,
            'description_translations' => $this->getTranslations('description'),
            'terms' => $this->terms,
            'terms_translations' => $this->getTranslations('terms'),
            'meta' => $this->meta,
            'mediaurls' => $this->getMediaUrlsAttribute(),
            'usage' => $this->usage,
            'type' => $this->type,
            'condition_type' => $this->condition_type,
            'condition_value' => $this->condition_value,
            'reward' => $this->reward,
            'reward_type' => $this->reward_type,
            'expires_at' => $this->expires_at,
            'partner_id' => $this->partner_id
        ];
    }
}
