<?php

namespace Vtlabs\Event\Http\Resources;

use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Event\Models\Artist;

class ArtistResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'title_translations' => $this->getTranslations('title'),
            'short_description' => $this->short_description,
            'short_description_translations' => $this->getTranslations('short_description'),
            'description' => $this->description,
            'description_translations' => $this->getTranslations('description'),
            'meta' => $this->meta,
            'mediaurls' => $this->getMediaUrlsAttribute(),
            'favourite_count' => $this->favoritesCount,
            'is_favourite' => $this->isFavourite ? 1 : 0,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at
        ];
    }
}
