<?php

namespace Vtlabs\Event\Http\Controllers\Api;

use Illuminate\Http\Request;
use Vtlabs\Core\Helpers\CoreHelper;
use Illuminate\Support\Facades\Auth;
use Rennokki\Plans\Models\PlanModel;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Payment\Http\Resources\PaymentResource;

/**
 * @group  Plan
 *
 * APIs for plans
 */
class PlanController extends Controller
{
    public function index()
    {
        return response()->json(PlanModel::get());
    }

    public function purchasePlan(PlanModel $plan, Request $request)
    {
        $request->validate([
            'payment_method_slug' => 'required|exists:payment_methods,slug'
        ]);

        // payment
        $payment = Auth::user()->createPayment($plan, $plan->price, $request->payment_method_slug);

        return new PaymentResource($payment);
    }

    public function redeemMembershipPoints(Request $request)
    {
        $user = Auth::user();
        $meta = $user->meta;
        $settings = CoreHelper::settingsAsDictionary();

        if (floatval($meta['points']) >= $settings['points_redemption_rate']) {
            $redeemValue = ($meta['points'] * $settings['points_redemption_rate']);

            $meta['points'] = 0;
            $user->meta = $meta;
            $user->save();

            $user->deposit($redeemValue, 'deposit', [
                'description' => $settings['currency_code'] . ' ' . $redeemValue . ' redeemed in wallet',
                'type' => 'deposit'
            ]);

            return response()->json(['redeem_value' => $redeemValue]);
        }

        return response()->json(['message' => 'Not enough points to redeeem']);
    }
}
