<?php

namespace Vtlabs\Event\Http\Controllers\Api;

use Illuminate\Http\Request;
use Vtlabs\Event\Models\Partner;
use Vtlabs\Event\Filters\PartnerFilter;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Event\Http\Resources\PartnerResource;

/**
 * @group Partner
 *
 * APIs for partner requests
 */
class PartnerController extends Controller
{
    public function __construct()
    {
        if (array_key_exists('HTTP_AUTHORIZATION', $_SERVER)) {
            $this->middleware('auth:api');
        }
    }

    public function index(Request $request)
    {
        $request->validate([
            'lat' => 'sometimes|numeric',
            'long' => 'sometimes|numeric',
            'sort' => 'sometimes|in:distance,default'
        ]);

        $partners = Partner::filter($request->all(), PartnerFilter::class)->get();
        return PartnerResource::collection($partners);
    }
}
