<?php

namespace Vtlabs\Event\Http\Controllers\Api;

use Illuminate\Http\Request;
use Vtlabs\Event\Models\Feature;
use Vtlabs\Core\Helpers\CoreHelper;
use Illuminate\Support\Facades\Auth;
use Vtlabs\Event\Filters\FeatureFilter;
use Vtlabs\Event\Models\Featureresponse;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Event\Http\Resources\FeatureResource;
use Vtlabs\Event\Http\Resources\FeatureresponseResource;

/**
 * @group Feature
 *
 * APIs for feature requests
 */
class FeatureController extends Controller
{
    public function __construct()
    {
        if (array_key_exists('HTTP_AUTHORIZATION', $_SERVER)) {
            $this->middleware('auth:api');
        }
    }

    public function index(Request $request)
    {
        $features = Feature::filter($request->all(), FeatureFilter::class)->get();
        return FeatureResource::collection($features);
    }

    public function submitResponse(Feature $feature, Request $request)
    {
        $request->validate([
            'meta' => 'required|json'
        ]);

        $request->merge(['feature_id' => $feature->id, 'user_id' => Auth::id()]);

        CoreHelper::requestMergeJsonField();

        $response = Featureresponse::create($request->only(['meta', 'feature_id', 'user_id']));

        return new FeatureresponseResource($response);
    }
}
