<?php

namespace Vtlabs\Event\Http\Controllers\Api;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Vtlabs\Event\Models\Coupon;
use Vtlabs\Core\Models\User\User;
use Vtlabs\Event\Filters\CouponFilter;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Event\Http\Resources\CouponResource;

/**
 * @group Coupon
 *
 * APIs for coupon requests
 */
class CouponController extends Controller
{
    public function __construct()
    {
        if (array_key_exists('HTTP_AUTHORIZATION', $_SERVER)) {
            $this->middleware('auth:api');
        }
    }

    public function index(Request $request)
    {
        $coupons = Coupon::filter($request->all(), CouponFilter::class)->get();
        return CouponResource::collection($coupons);
    }

    public function redeem(Coupon $coupon, Request $request)
    {
        $request->validate([
            'user_id' => 'required|exists:users,id',
            'bill_amount' => 'required|numeric|min:0'
        ]);


        list($result, $message) = $coupon->canRedeem($request->user_id, $request->bill_amount);

        if ($result) {
            $coupon->users()->attach($request->user_id, ['used_at' => Carbon::now(), 'bill_amount' => $request->bill_amount]);
            
            User::where('id', $request->user_id)->increment('bill_amount', $request->bill_amount);
            
            return response()->json([]);
        } else {
            return response()->json(['message' => $message], 400);
        }
    }
}
