<?php

namespace Vtlabs\Event\Http\Controllers\Api\Admin;

use Illuminate\Http\Request;
use Vtlabs\Event\Models\Featureresponse;
use Vtlabs\Core\Helpers\CoreHelper;
use Illuminate\Support\Facades\Gate;
use Vtlabs\Event\Filters\FeatureresponseFilter;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Event\Http\Resources\Admin\FeatureresponseAdminResource;

class FeatureresponseController extends Controller
{
    public function index(Request $request)
    {
        $request->validate([
            'title' => 'sometimes|string'
        ]);

        $featureresponses = Featureresponse::filter($request->all(), FeatureresponseFilter::class)->latest()->paginate();

        return FeatureresponseAdminResource::collection($featureresponses);
    }

    public function store(Request $request)
    {
        $request->validate([
            'title_translations' => 'required|translation',
            'description_translations' => 'sometimes|translation',
            'meta' => 'sometimes|json|nullable',
            'sort_order' => 'sometimes',
            'images.*' => 'sometimes|image',
        ]);

        CoreHelper::requestMergeJsonField();

        $featureresponse = Featureresponse::create($request->only(['title', 'description', 'meta', 'sort_order']));

        CoreHelper::requestSaveImage($featureresponse, 'image');

        return new FeatureresponseAdminResource($featureresponse->fresh());
    }

    public function show(Featureresponse $featureresponse)
    {
        return new FeatureresponseAdminResource($featureresponse);
    }

    public function update(Featureresponse $featureresponse, Request $request)
    {
        $request->validate([
            'title_translations' => 'required|translation',
            'description_translations' => 'required|translation',
            'meta' => 'sometimes|json|nullable',
            'images.*' => 'sometimes|image',
        ]);

        CoreHelper::requestMergeJsonField();

        $featureresponse->fill($request->only(['title', 'short_description', 'description', 'meta']));
        $featureresponse->save();

        CoreHelper::requestSaveImage($featureresponse, 'image');

        return new FeatureresponseAdminResource($featureresponse->fresh());
    }

    public function destroy(Featureresponse $featureresponse)
    {
        Gate::authorize('delete');

        $featureresponse->delete();

        return response()->json([], 200);
    }
}
