<?php

namespace Vtlabs\Event\Http\Controllers\Api\Admin;

use Illuminate\Http\Request;
use Vtlabs\Event\Models\Feature;
use Vtlabs\Core\Helpers\CoreHelper;
use Illuminate\Support\Facades\Gate;
use Vtlabs\Event\Filters\FeatureFilter;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Event\Http\Resources\Admin\FeatureAdminResource;

class FeatureController extends Controller
{
    public function index(Request $request)
    {
        $request->validate([
            'title' => 'sometimes|string'
        ]);

        $features = Feature::filter($request->all(), FeatureFilter::class)->ordered()->paginate();

        return FeatureAdminResource::collection($features);
    }

    public function store(Request $request)
    {
        $request->validate([
            'title_translations' => 'required|translation',
            'description_translations' => 'sometimes|translation',
            'meta' => 'sometimes|json|nullable',
            'sort_order' => 'sometimes',
            'image' => 'sometimes|image',
        ]);

        CoreHelper::requestMergeJsonField();

        $feature = Feature::create($request->only(['title', 'description', 'meta', 'sort_order']));

        CoreHelper::requestSaveImage($feature, 'image');

        return new FeatureAdminResource($feature->fresh());
    }

    public function show(Feature $feature)
    {
        return new FeatureAdminResource($feature);
    }

    public function update(Feature $feature, Request $request)
    {
        $request->validate([
            'title_translations' => 'required|translation',
            'description_translations' => 'sometimes|translation',
            'meta' => 'sometimes|json|nullable',
            'image' => 'sometimes|image',
        ]);

        CoreHelper::requestMergeJsonField();

        $feature->fill($request->only(['title', 'short_description', 'description', 'meta']));
        $feature->save();

        CoreHelper::requestSaveImage($feature, 'image');

        return new FeatureAdminResource($feature->fresh());
    }

    public function destroy(Feature $feature)
    {
        Gate::authorize('delete');

        $feature->delete();

        return response()->json([], 200);
    }
}
