<?php

namespace Vtlabs\Event\Http\Controllers\Api\Admin;

use Illuminate\Http\Request;
use Vtlabs\Event\Models\Coupon;
use Vtlabs\Core\Helpers\CoreHelper;
use Illuminate\Support\Facades\Gate;
use Vtlabs\Event\Filters\CouponFilter;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Event\Http\Resources\Admin\CouponAdminResource;

class CouponController extends Controller
{
    public function index(Request $request)
    {
        $request->validate([
            'title' => 'sometimes|string'
        ]);

        $coupons = Coupon::filter($request->all(), CouponFilter::class)->latest()->paginate();

        return CouponAdminResource::collection($coupons);
    }

    public function store(Request $request)
    {
        $request->validate([
            'title_translations' => 'required|translation',
            'description_translations' => 'required|translation',
            'terms_translations' => 'required|translation',
            'usage' => 'required',
            'type' => 'required',
            'condition_type' => 'required',
            'condition_value' => 'required',
            'reward' => 'required',
            'reward_type' => 'required',
            'expires_at' => 'sometimes|nullable',
            'partner_id' => 'sometimes|nullable',
            'meta' => 'sometimes|json|nullable',
            'image' => 'sometimes|image'
        ]);

        CoreHelper::requestMergeJsonField();

        $coupon = Coupon::create($request->only(['title', 'description', 'terms', 'usage', 'type', 'condition_type', 'condition_value', 'reward', 'reward_type', 'expires_at', 'meta', 'partner_id']));

        CoreHelper::requestSaveImage($coupon, 'image');

        return new CouponAdminResource($coupon->fresh());
    }

    public function show(Coupon $coupon)
    {
        return new CouponAdminResource($coupon);
    }

    public function update(Coupon $coupon, Request $request)
    {
        $request->validate([
            'title_translations' => 'required|translation',
            'description_translations' => 'required|translation',
            'terms_translations' => 'required|translation',
            'usage' => 'required',
            'type' => 'required',
            'condition_type' => 'required',
            'condition_value' => 'required',
            'reward' => 'required',
            'reward_type' => 'required',
            'expires_at' => 'sometimes',
            'meta' => 'sometimes|json|nullable',
            'image' => 'sometimes|image',
            'partner_id' => 'sometimes|nullable'
        ]);

        CoreHelper::requestMergeJsonField();

        $coupon->fill($request->only(['title', 'description', 'terms', 'usage', 'type', 'condition_type', 'condition_value', 'reward', 'reward_type', 'expires_at', 'meta', 'partner_id']));
        $coupon->save();

        CoreHelper::requestSaveImage($coupon, 'image');

        return new CouponAdminResource($coupon->fresh());
    }

    public function destroy(Coupon $coupon)
    {
        Gate::authorize('delete');

        $coupon->delete();

        return response()->json([], 200);
    }
}
