<?php

namespace Vtlabs\Event\Filters;

use EloquentFilter\ModelFilter;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\App;
use Vtlabs\Core\Helpers\CoreHelper;

class PartnerFilter extends ModelFilter
{
    public function setup()
    {        
        // filter vendors based on user location
        // @TODO: read distance value from settings
        if($this->input('long') && $this->input('lat')) {
            $subqueryDistance = "ST_Distance_Sphere(Point(longitude,"
                . " latitude),"
                . " Point(" . $this->input('long') . ", " . $this->input('lat') . "))"
                . " as distance";

            $this->select('*', DB::raw($subqueryDistance));
        }

        // default sorting
        if(!$this->input('sort')) {
            $this->latest();
        }
    }

    public function title($title)
    {
        return CoreHelper::searchTranslated($this, 'title', App::getLocale(), $title);
    }

    public function sort($sort)
    {
        switch($sort){
            case 'distance':
                $this->orderBy('distance');
            default:
                $this->ordered();
        }
    }
}
