<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEvCouponsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ev_coupons', function (Blueprint $table) {
            $table->id();
            $table->string('code', 16)->unique()->nullable();
            $table->json('title')->nullable();
            $table->json('description')->nullable();
            $table->json('terms')->nullable();
            $table->json('meta')->nullable();
            $table->smallInteger('usage')->default(0);
            $table->enum('type', ['offer', 'partner_discount']);
            $table->enum('condition_type', ['minimum', 'exact'])->nullable();
            $table->double('condition_value', 8, 2)->default(0);
            $table->double('reward', 8, 2);
            $table->enum('reward_type', ['fixed', 'percent']);
            $table->date('expires_at')->nullable();
            $table->foreignId('partner_id')->nullable()->constrained('ev_partners')->cascadeOnDelete();
            $table->timestamps();
        });

        Schema::create('ev_coupons_users', function (Blueprint $table) {
            $table->unsignedInteger('user_id');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            $table->timestamp('used_at');
            $table->double('bill_amount', 8, 2)->default(0);
            
            $table->foreignId('coupon_id')->nullable()->constrained('ev_coupons')->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ev_coupons_users', function (Blueprint $table) {
            $table->dropForeign(['user_id']);
            $table->dropForeign(['coupon_id']);
        });

        Schema::dropIfExists('ev_coupons_users');

        Schema::dropIfExists('ev_coupons');
    }
}
