<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFeaturesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::create('ev_features', function (Blueprint $table) {
            $table->id();
            $table->json('title');
            $table->json('description')->nullable();
            $table->json('meta')->nullable();
            $table->integer('sort_order')->default(1);
            $table->timestamps();
        });

        Schema::create('ev_featureresponses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('feature_id')->constrained('ev_features')->cascadeOnDelete();
            $table->json('meta')->nullable();

            // user
            $table->integer('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ev_featureresponses', function (Blueprint $table) {
            $table->dropForeign(['feature_id']);
            $table->dropForeign(['user_id']);
        });

        Schema::dropIfExists('ev_featureresponses');
        Schema::dropIfExists('ev_features');
    }
}
