<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVenuesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ev_venues', function (Blueprint $table) {
            $table->increments('id');
            $table->json('title');
            $table->json('short_description')->nullable();
            $table->json('description')->nullable();
            $table->json('meta')->nullable();

            // address
            $table->string('area')->nullable();
            $table->string('address')->nullable();
            $table->decimal('longitude', 15, 7)->default(0.0);
            $table->decimal('latitude', 15, 7)->default(0.0);
            
            $table->timestamps();
        });

        Schema::create('ev_auditoriums', function (Blueprint $table) {
            $table->increments('id');
            $table->json('title')->nullable();
            $table->json('meta')->nullable();

            $table->integer('venue_id')->unsigned()->nullable();
            $table->foreign('venue_id')->references('id')->on('ev_venues')->onDelete('cascade');
            
            $table->timestamps();
        });

        Schema::create('ev_seats', function (Blueprint $table) {
            $table->increments('id');
            $table->json('title')->nullable();
            $table->string('row')->nullable();
            $table->string('column')->nullable();
            $table->json('meta')->nullable();

            $table->enum('type', ['standing', 'seat'])->default('seat');

            $table->integer('auditorium_id')->unsigned()->nullable();
            $table->foreign('auditorium_id')->references('id')->on('ev_auditoriums')->onDelete('cascade');

            $table->integer('category_id')->unsigned();
            $table->foreign('category_id')->references('id')->on('categories')->onDelete('cascade');
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ev_seats', function (Blueprint $table) {
            $table->dropForeign(['auditorium_id']);
            $table->dropForeign(['category_id']);
        });

        Schema::table('ev_auditoriums', function (Blueprint $table) {
            $table->dropForeign(['venue_id']);
        });

        Schema::dropIfExists('ev_venues');
    }
}
