<?php

namespace Vtlabs\Event\Models;

use EloquentFilter\Filterable;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Vtlabs\Category\Models\Category;

class Seat extends Model
{
    use Filterable,
        HasTranslations;

    protected $table = 'ev_seats';

    protected $guarded = [];

    protected $casts = [
        'title' => 'array',
        'meta' => 'json'
    ];

    public $translatable = ['title'];

    public function category()
    {
        return $this->belongsTo(Category::class);
    }
}