<?php

namespace Vtlabs\Event\Models;

use EloquentFilter\Filterable;
use Vtlabs\Event\Models\Artist;
use Vtlabs\Event\Models\OrderSeat;
use Spatie\ModelStatus\HasStatuses;
use Vtlabs\Category\Models\Category;
use Rennokki\Rating\Traits\CanBeRated;
use Vtlabs\Event\Models\EventCategory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Vtlabs\Core\Traits\CoreHasMediaTrait;
use Spatie\MediaLibrary\HasMedia;
use ChristianKuri\LaravelFavorite\Traits\Favoriteable;

class Event extends Model implements HasMedia
{
    const STATUS_PUBLISHED = 'published';
    const STATUS_UNPUBLISHED = 'unpublished';
    const STATUS_DRAFT = 'draft';

    use Filterable,
    Favoriteable,
    HasStatuses,
    HasTranslations,
    CoreHasMediaTrait,
    CanBeRated;

    protected $table = 'ev_events';

    protected $guarded = [];

    protected $casts = [
        'title' => 'json',
        'description' => 'json',
        'short_description' => 'json',
        'meta' => 'json',
        'latitude' => 'decimal:2',
        'longitude' => 'decimal:2',
        'distance' => 'decimal:2',
    ];

    public $translatable = ['title', 'description', 'short_description'];

    public function getIsFavouriteAttribute()
    {
        return $this->isFavorited();
    }

    public function scopeOrdered($query)
    {
        return $query->orderBy('created_at');
    }

    public function auditorium()
    {
        return $this->belongsTo(Auditorium::class);
    }

    public function eventCategories()
    {
        return $this->belongsToMany(Category::class, 'ev_event_categories')->withPivot('price');
    }

    public function artists()
    {
        return $this->belongsToMany(Artist::class, 'ev_event_artists')->withPivot('time_from', 'time_to');
    }

    public function seats()
    {
        return $this->belongsToMany(OrderSeat::class, 'ev_order_seats');
    }
}
