<?php

namespace Vtlabs\Event\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class AuditoriumResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'meta' => $this->meta,
            
            'title' => $this->title,
            'title_translations' => $this->getTranslations('title'),
            
            'venue_id' => $this->venue_id,
            'venue' => new VenueResource($this->venue),
            
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at
        ];
    }
}
