<?php

namespace Vtlabs\Event\Models;

use EloquentFilter\Filterable;
use Vtlabs\Payment\Traits\CanBePaid;
use Vtlabs\Payment\Contracts\Payable;
use Illuminate\Database\Eloquent\Model;

class EventOrder extends Model implements Payable
{
    use CanBePaid, Filterable;
    
    protected $table = 'ev_orders';

    protected $guarded = [];

    protected $casts = [
        'meta' => 'array',
        'subtotal' => 'float',
        'taxes' => 'float',
        'total' => 'float',
        'discount' => 'float',
    ];

    public function scopeOrdered($query)
    {
        return $query->orderBy('created_at', 'desc');
    }

    public function event()
    {
        return $this->belongsTo(Event::class);
    }

    public function user()
    {
        return $this->belongsTo(config('auth.models.user'));
    }

    public function seats()
    {
        return $this->belongsToMany(Seat::class, 'ev_order_seats', 'order_id', 'seat_id');
    }
}
