<?php

namespace Vtlabs\Event\Filters;

use EloquentFilter\ModelFilter;
use Vtlabs\Event\Models\Artist;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\App;
use Vtlabs\Core\Helpers\CoreHelper;
use Illuminate\Support\Facades\Auth;

class EventFilter extends ModelFilter
{
    public function setup()
    {        
        // filter vendors based on user location
        // @TODO: read distance value from settings
        if($this->input('long') && $this->input('lat')) {
            $subqueryDistance = "ST_Distance_Sphere(Point(longitude,"
                . " latitude),"
                . " Point(" . $this->input('long') . ", " . $this->input('lat') . "))"
                . " as distance";

            $this->select('*', DB::raw($subqueryDistance));
        }

        // default sorting
        if(!$this->input('sort')) {
            $this->ordered();
        }
    }

    public function search($search)
    {
        return CoreHelper::searchTranslated($this, 'title', App::getLocale(), $search);
    }

    public function title($title)
    {
        return CoreHelper::searchTranslated($this, 'title', App::getLocale(), $title);
    }

    public function sort($sort)
    {
        switch($sort){
            case 'distance':
                $this->orderBy('distance');
            default:
                $this->ordered();
        }
    }

    public function artist($artist)
    {
        $this->whereHas('artists', function($query) use ($artist){
            return $query->where('id', $artist);
        });
    }

    public function favouriteArtists($favouriteArtists)
    {
        if(Auth::check()) {
            $favouriteArtists = Auth::user()->favorite(Artist::class)->pluck(['id']);

            $this->whereHas('artists', function($query) use ($favouriteArtists){
                return $query->whereIn('id', $favouriteArtists);
            });
        }
    }
}
