<?php
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

use Illuminate\Http\Request;

Route::middleware('api')->prefix('api')->name('api')->namespace('Vtlabs\Event\Http\Controllers\Api')->group(function () {

    // admin api
    Route::namespace('Admin')->name('admin')->prefix('admin/ev')->group(function () {
        Route::middleware('auth:api')->group(function () {
            Route::apiResource('artists', 'ArtistController');
            Route::apiResource('venues', 'VenueController');
            Route::apiResource('auditoriums', 'AuditoriumController');
            Route::get('auditoriums/{auditorium}/categories', 'AuditoriumController@categories');
            Route::apiResource('events', 'EventController');
            Route::apiResource('orders', 'EventOrderController')->except(['create', 'update']);
        });
    });

    // app/web api
    Route::prefix('ev')->group(function () {
        Route::middleware('auth:api')->group(function () {

            // event
            Route::get('events/favourites', 'EventController@favourites');
            Route::post('events/favourites/{event}', 'EventController@toggleFavourite');
            Route::get('orders', 'EventOrderController@index');
            Route::post('orders/{event}', 'EventOrderController@store');

            // artist
            Route::get('artist/favourites', 'ArtistController@favourites');
            Route::post('artist/favourites/{artist}', 'ArtistController@toggleFavourite');
        });

        // event
        Route::get('events', 'EventController@index');
        Route::get('events/{event}/favoriters', 'EventController@favoriters');
        Route::get('events/{event}/seats', 'EventController@seats');
        Route::get('events/{event}/users-attending', 'EventController@usersAttending');

        // artist
        Route::get('artist/{artist}', 'ArtistController@show');
    });
});
