<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEventOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ev_orders', function (Blueprint $table) {
            $table->increments('id');
            $table->json('meta')->nullable();

            $table->double('subtotal', 8,2);
            $table->double('taxes', 8,2);
            $table->double('total', 8,2);
            $table->double('discount', 8,2);

            // event
            $table->integer('event_id')->unsigned()->nullable();
            $table->foreign('event_id')->references('id')->on('ev_events')->onDelete('cascade');
            
            // customer
            $table->integer('user_id')->unsigned()->nullable();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            $table->timestamps(); 
        });

        Schema::create('ev_order_seats', function (Blueprint $table) {
            // event order
            $table->integer('order_id')->unsigned();
            $table->foreign('order_id')->references('id')->on('ev_orders')->onDelete('cascade');

            //seat
            $table->integer('seat_id')->unsigned();
            $table->foreign('seat_id')->references('id')->on('ev_seats')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ev_order_seats', function (Blueprint $table) {
            $table->dropForeign(['order_id']);
            $table->dropForeign(['seat_id']);
        });

        Schema::dropIfExists('ev_order_seats');

        Schema::table('ev_orders', function (Blueprint $table) {
            $table->dropForeign(['event_id']);
            $table->dropForeign(['user_id']);
        });

        Schema::dropIfExists('ev_orders');
    }
}
