<?php

namespace Vtlabs\Ecommerce\Services;

use Mike42\Escpos\Printer;
use Vtlabs\Ecommerce\Models\Order;
use Mike42\Escpos\PrintConnectors\FilePrintConnector;

class item
{
    private $name;
    private $price;
    private $dollarSign;

    public function __construct($name = '', $price = '', $dollarSign = false)
    {
        $this->name = $name;
        $this->price = $price;
        $this->dollarSign = $dollarSign;
    }

    public function __toString()
    {
        $rightCols = 10;
        $leftCols = 38;
        if ($this->dollarSign) {
            $leftCols = $leftCols / 2 - $rightCols / 2;
        }
        $left = str_pad($this->name, $leftCols);

        $sign = ($this->dollarSign ? '$ ' : '');
        $right = str_pad($sign . $this->price, $rightCols, ' ', STR_PAD_LEFT);
        return "$left$right\n";
    }
}

class PrintOrderService
{
    private $order;

    public function __construct(Order $order)
    {
        $this->order = $order;
    }

    public function printEscpos()
    {
        /* Start the printer */
        $path = tempnam(sys_get_temp_dir(), 'prefix');
        $connector = new FilePrintConnector($path);
        $printer = new Printer($connector);

        /* Name of shop */
        //$printer->selectPrintMode(Printer::MODE_DOUBLE_WIDTH | Printer::MODE_DOUBLE_HEIGHT);
        //$printer->selectPrintMode(Printer::MODE_EMPHASIZED | Printer::MODE_DOUBLE_HEIGHT | Printer::MODE_DOUBLE_HEIGHT);
        //$printer -> selectPrintMode(Printer::MODE_EMPHASIZED);
        //$printer -> setTextSize(4, 4);

        $printer->setEmphasis(true);
        $printer->setJustification(Printer::JUSTIFY_CENTER);
        $printer->text(strtoupper($this->greeklish($this->order->vendor->name)));
        $printer->feed();
        $printer->feed();
        $printer->setJustification(Printer::JUSTIFY_LEFT);
        $printer->setEmphasis(false);
        $printer->selectPrintMode();
        //$printer -> setTextSize(3, 3);
        // $printer->selectPrintMode(Printer::MODE_DOUBLE_WIDTH);
        //$printer->text(strtoupper($this->greeklish(env('PRINT_ADDRESS'))));
        //$printer->feed();
        // $printer -> setTextSize(2, 2);
        //$printer->text(strtoupper($this->greeklish(env('PRINT_PHONE'))));
        //$printer->feed();

        

        $printer->text(wordwrap(strtoupper($this->greeklish($this->order->vendor->address)), 40));
        $printer->feed();
        
        $printer->text("Contact: " . strtoupper($this->greeklish($this->order->vendor->user->mobile_number)));
        $printer->feed();

        // $logo = EscposImage::load(public_path('assets/vendor/product/receipt-logo.png'), false);
        // $printer -> graphics($logo);

        $printer->text("\n-----------------------------------------\n");
        //$printer->feed();

        /* date and order id */
        $orderType = '';
        if ($this->order->order_type = Order::ORDER_TYPE_NORMAL) {
            $orderType = 'Delivery';
        }

        if ($this->order->order_type = Order::ORDER_TYPE_TAKEAWAY) {
            $orderType = 'Takeaway';
        }

        if ($this->order->order_type = Order::ORDER_TYPE_DINEIN) {
            $orderType = 'Dinein';
        }

        if ($this->order->order_type = Order::ORDER_TYPE_CUSTOM) {
            $orderType = 'Custom';
        }

        $printer->setEmphasis(true);
        $printer->text('Payment - '. strtoupper($this->order->payment->paymentMethod->title));
        $printer->setEmphasis(false);
        $printer->feed();
        $printer->text($this->greeklish('Order number: ' . $this->order->id));
        $printer->feed();
        $printer->text($this->order->created_at);
        //$printer->feed();

        $printer->text("\n-----------------------------------------\n");
        //$printer->feed();

        /* Items */
        //$printer -> setJustification(Printer::JUSTIFY_LEFT);
        //$printer -> setEmphasis(true);
        //$printer -> text(new item('', '$'));
        //$printer -> setEmphasis(false);

        $productsTotal = 0;
        $extrasTotal = 0;
        $addonsTotal = 0;

        foreach ($this->order->products as $product) {
            $productTotal = $product->total;
            

            foreach ($product->addonChoices as $choice) {
                $productTotal -= $choice->total;

                // check if extras or addons
                if (strpos($choice->addonChoice->title, '$$') === 0) {
                    $extrasTotal += $choice->total;
                } else {
                    $addonsTotal += $choice->total;
                }
            }

            $printer->text($this->printLine($product->quantity . ' x ' . substr($product->vendorProduct->product->title, 0, 40), number_format($productTotal, 2)));

            foreach ($product->addonChoices as $choice) {
                $printer->text($this->printLine('  ' . substr($choice->addonChoice->title, 0, 40), number_format($choice->total, 2)));
            }

            $productsTotal += $productTotal;
        }

        $printer->feed();
        //$printer -> setEmphasis(true);

        $printer->text($this->printLine('Item Total', number_format($productsTotal, 2)));
        if($addonsTotal > 0) {
            $printer->text($this->printLine('Addons Total', number_format($addonsTotal, 2)));
        }
        if($extrasTotal > 0) {
            $printer->text($this->printLine('Extras Total', number_format($extrasTotal, 2)));
        }
        
        if($this->order->foodstamp_total > 0) {
            $printer->text($this->printLine('Food Stamp', number_format($this->order->foodstamp_total, 2)));
        }

        $printer->text($this->printLine('Subtotal', number_format($this->order->subtotal, 2)));
        //$printer -> setEmphasis(false);
        //$printer->feed();

        /* Tax and total */
        $printer->text($this->printLine('Taxes', number_format($this->order->taxes, 2)));
        //$printer->feed();

        $printer->text($this->printLine('Delivery Fee', number_format($this->order->delivery_fee, 2)));
        //$printer->feed();

        $printer->text($this->printLine('Discount', number_format($this->order->discount, 2)));
        //$printer->feed();

        //$printer -> selectPrintMode(Printer::MODE_DOUBLE_WIDTH);
        $printer->setEmphasis(true);
        $printer->text($this->printLine('Total', number_format($this->order->total, 2)));
        $printer->setEmphasis(false);
        //$printer->feed();
        //$printer->selectPrintMode();

        /* Footer */
        //$printer->feed();
        //$printer->feed();
        //$printer->setJustification(Printer::JUSTIFY_CENTER);

        if ($this->order->user) {
            $printer->text("\n-----------------------------------------\n");
            $printer->text("Customer ID:" . $this->order->user->id . " \n");
            $printer->text("Customer Details:\n");
            $printer->text("Customer Name:" . $this->greeklish($this->order->user->name) . " \n");
            $printer->text("Customer Mobile:" . $this->order->user->mobile_number . " \n");
            $printer->text("Customer Address:" . $this->greeklish($this->order->address->formatted_address) . " \n");
            $printer->feed();
        } else if ($this->order->customer_name) {
            $printer->text("\n-----------------------------------------------\n");
            $printer->text("Customer Details:\n");
            $printer->text("Customer Name:" . $this->order->customer_name . " \n");
            $printer->text("Customer Mobile:" . $this->order->customer_mobile . " \n");
        }

        if($this->order->foodstamp_total > 0) {
            // food stamp related barcode
            $foodstampTotal = $this->order->foodstamp_total;
            $foodstampTotalInCents = str_pad(intval(round($foodstampTotal * 100)), 5, '0', STR_PAD_LEFT);
            $foodstampBarcode = sprintf("202444%s5", $foodstampTotalInCents);
            $printer->text("\n-----------------------------------------\n");
            $printer->text(sprintf("Food Stamp: %s\n", number_format($foodstampTotal, 2)));
            $printer->barcode($foodstampBarcode, Printer::BARCODE_UPCA);
            $printer->text($foodstampBarcode . "\n");
            $printer->text("\n-----------------------------------------\n");
        }

        $taxableTotal = $this->order->total - $this->order->foodstamp_total;
        if($taxableTotal > 0) {
            $taxableTotalInCents = str_pad(intval(round($taxableTotal * 100)), 5, '0', STR_PAD_LEFT);
            $taxableTotalBarcode = sprintf("202445%s2", $taxableTotalInCents);
            $printer->text("\n-----------------------------------------\n");
            $printer->text(sprintf("Total Tax: %s\n", number_format($taxableTotal, 2)));
            $printer->barcode($taxableTotalBarcode, Printer::BARCODE_UPCA);
            $printer->text($taxableTotalBarcode . "\n");
            $printer->text("\n-----------------------------------------\n");
        }

        $printer->text("\n-----------------------------------------\n");
        $printer->text('Thank you for ordering with us!');
        $printer->feed(3);

        /* Cut the receipt and open the cash drawer */
        //$printer->cut();
        //$printer->pulse();

        $printer->close();
        
        return file_get_contents($path);
    }

    private function printLine($title, $price)
    {
        $rightCols = 10;
        $leftCols = 38;
        
        $title = $this->greeklish($title);

        $left = str_pad($title, $leftCols);

        $right = str_pad($price, $rightCols, ' ', STR_PAD_LEFT);
        return "$left$right\n";
    }
    
    private function greeklish($new_text){

        $greek_len   = array('α','ά','Ά','Α','β','Β','γ', 'Γ', 'δ','Δ','ε','έ','Ε','Έ','ζ','Ζ','η','ή','Η','θ','Θ','ι','ί','ϊ','ΐ','Ι','Ί', 'κ','Κ','λ','Λ','μ','Μ','ν','Ν','ξ','Ξ','ο','ό','Ο','Ό','π','Π','ρ','Ρ','σ','ς', 'Σ','τ','Τ','υ','ύ','Υ','Ύ','φ','Φ','χ','Χ','ψ','Ψ','ω','ώ','Ω','Ώ',' ',"'","'",',');

        $english_len = array('a', 'a','A','A','b','B','g','G','d','D','e','e','E','E','z','Z','i','i','I','th','Th', 'i','i','i','i','I','I','k','K','l','L','m','M','n','N','x','X','o','o','O','O','p','P' ,'r','R','s','s','S','t','T','u','u','Y','Y','f','F','ch','Ch','ps','Ps','o','o','O','O',' ','',' ',' ');
        $new_text  = str_replace($greek_len,$english_len,$new_text);
        return $new_text;
    }
}
