<?php

namespace Vtlabs\Ecommerce\Jobs;

use Illuminate\Bus\Queueable;
use Vtlabs\Ecommerce\Models\Order;
use Illuminate\Support\Facades\Log;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Vtlabs\Core\Services\FirebaseService;
use Vtlabs\Ecommerce\Filters\OrderFilter;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Vtlabs\Ecommerce\Services\OrderService;
use Vtlabs\Ecommerce\Http\Resources\OrderResource;

class AssignDeliveryProfile implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct()
    {
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        try {
            Log::info('Executing  AssignDeliveryProfile job');

            // get all orders for which we need to find delivery profile for pickup
            $orders =  Order::filter(['status' => 'accepted', 'meta' => ['is_pickup' => 1], 'picker_not_assigned' => 1, 'pickup_time_lapsed' => 1], OrderFilter::class)->get();

            Log::info('Found ' . count($orders) . ' pickable orders');
            foreach ($orders as $order) {
                $orderService = new OrderService($order);
                $orderService->sendDeliveryRequest(true);
            }

            // get all orders for which we need to find delivery profile for delivery
            $orders =  Order::filter(['status' => 'prepared', 'meta' => ['is_pickup' => 1], 'delivery_not_assigned' => 1, 'delivery_time_lapsed' => 1], OrderFilter::class)->get();

            Log::info('Found ' . count($orders) . ' deliverable orders');
            foreach ($orders as $order) {
                $orderService = new OrderService($order);
                $orderService->sendDeliveryRequest(false);
            }
        } catch (\Exception $ex) {
            Log::error($ex->getMessage());
        }
    }
}
