<?php

namespace Vtlabs\Ecommerce\Services;

use Carbon\Carbon;
use Mike42\Escpos\Printer;
use Mike42\Escpos\EscposImage;
use Vtlabs\Ecommerce\Models\Order;
use Vtlabs\Core\Helpers\CoreHelper;
use Mike42\Escpos\PrintConnectors\FilePrintConnector;

class item
{
    private $name;
    private $price;
    private $dollarSign;

    public function __construct($name = '', $price = '', $dollarSign = false)
    {
        $this->name = $name;
        $this->price = $price;
        $this->dollarSign = $dollarSign;
    }

    public function __toString()
    {
        $rightCols = 10;
        $leftCols = 38;
        if ($this->dollarSign) {
            $leftCols = $leftCols / 2 - $rightCols / 2;
        }
        $left = str_pad($this->name, $leftCols);

        $sign = ($this->dollarSign ? '$ ' : '');
        $right = str_pad($sign . $this->price, $rightCols, ' ', STR_PAD_LEFT);
        return "$left$right\n";
    }
}

class PrintOrderService
{
    private $order;

    public function __construct(Order $order)
    {
        $this->order = $order;
    }

    public function printEscpos()
    {
        /* Start the printer */
        $connector = new FilePrintConnector("php://stdout");
        $printer = new Printer($connector);

        /* Name of shop */
        //$printer->selectPrintMode(Printer::MODE_DOUBLE_WIDTH | Printer::MODE_DOUBLE_HEIGHT);
        //$printer->selectPrintMode(Printer::MODE_EMPHASIZED | Printer::MODE_DOUBLE_HEIGHT | Printer::MODE_DOUBLE_HEIGHT);
        //$printer -> selectPrintMode(Printer::MODE_EMPHASIZED);
        //$printer -> setTextSize(4, 4);

        $printer->setEmphasis(true);
        $printer->text(strtoupper(env('PRINT_NAME')));
        $printer->feed();
        //$printer -> setTextSize(3, 3);
        // $printer->selectPrintMode(Printer::MODE_DOUBLE_WIDTH);
        $printer->text(strtoupper(env('PRINT_ADDRESS')));
        $printer->feed();
        // $printer -> setTextSize(2, 2);
        $printer->text(strtoupper(env('PRINT_PHONE')));
        $printer->setEmphasis(false);
        $printer->selectPrintMode();
        //$printer->feed();

        // $logo = EscposImage::load(public_path('assets/vendor/product/receipt-logo.png'), false);
        // $printer -> graphics($logo);

        $printer->text("\n-----------------------------------------------\n");
        //$printer->feed();

        /* date and order id */
        $orderType = '';
        if ($this->order->order_type = Order::ORDER_TYPE_NORMAL) {
            $orderType = 'Delivery';
        }

        if ($this->order->order_type = Order::ORDER_TYPE_TAKEAWAY) {
            $orderType = 'Takeaway';
        }

        if ($this->order->order_type = Order::ORDER_TYPE_DINEIN) {
            $orderType = 'Dinein';
        }

        if ($this->order->order_type = Order::ORDER_TYPE_CUSTOM) {
            $orderType = 'Custom';
        }

        $printer->setEmphasis(true);
        $printer->text(strtoupper($orderType));
        $printer->setEmphasis(false);
        $printer->feed();
        $printer->text('Order number: ' . $this->order->id);
        $printer->feed();
        $printer->text($this->order->created_at);
        //$printer->feed();

        $printer->text("\n-----------------------------------------------\n");
        //$printer->feed();

        /* Items */
        //$printer -> setJustification(Printer::JUSTIFY_LEFT);
        //$printer -> setEmphasis(true);
        //$printer -> text(new item('', '$'));
        //$printer -> setEmphasis(false);
        foreach ($this->order->products as $product) {
            $printer->text($this->printLine($product->quantity . ' x ' . substr($product->vendorProduct->product->title, 0, 40), $product->total));

            foreach ($product->addonChoices as $choice) {
                $printer->text($this->printLine('  ' . substr($choice->addonChoice->title, 0, 40), ''));
            }
        }
        $printer->feed();
        //$printer -> setEmphasis(true);
        $printer->text($this->printLine('Subtotal', $this->order->subtotal));
        //$printer -> setEmphasis(false);
        //$printer->feed();

        /* Tax and total */
        $printer->text($this->printLine('Taxes', $this->order->taxes));
        //$printer->feed();

        $printer->text($this->printLine('Delivery Fee', $this->order->delivery_fee));
        //$printer->feed();

        $printer->text($this->printLine('Discount', $this->order->discount));
        //$printer->feed();

        //$printer -> selectPrintMode(Printer::MODE_DOUBLE_WIDTH);
        $printer->setEmphasis(true);
        $printer->text($this->printLine('Total', $this->order->total));
        $printer->setEmphasis(false);
        //$printer->feed();
        //$printer->selectPrintMode();

        /* Footer */
        //$printer->feed();
        //$printer->feed();
        //$printer->setJustification(Printer::JUSTIFY_CENTER);

        if ($this->order->user) {
            $printer->text("\n-----------------------------------------------\n");
            $printer->text("Customer ID:" . $this->order->user->id . " \n");
            $printer->text("Customer Details:\n");
            $printer->text("Customer Name:" . $this->order->user->name . " \n");
            $printer->text("Customer Mobile:" . $this->order->user->mobile_number . " \n");
            $printer->text("Customer Address:" . $this->order->address->formatted_address . " \n");
            $printer->feed();
        } else if ($this->order->customer_name) {
            $printer->text("\n-----------------------------------------------\n");
            $printer->text("Customer Details:\n");
            $printer->text("Customer Name:" . $this->order->customer_name . " \n");
            $printer->text("Customer Mobile:" . $this->order->customer_mobile . " \n");
        }

        $printer->text("\n-----------------------------------------------\n");
        $printer->text('Thank you for ordering with us!');
        $printer->feed(3);

        /* Cut the receipt and open the cash drawer */
        //$printer->cut();
        //$printer->pulse();

        $printer->close();
    }

    public function printHtml()
    {
        return '<!doctype html>
        <html lang="en">
        
        <head>
            <!-- Required meta tags -->
            <meta charset="utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1">
        
            <!-- Bootstrap CSS -->
            <!-- <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.1/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous"> -->
        
            <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.1/dist/css/bootstrap.min.css" integrity="sha384-zCbKRCUGaJDkqS1kPbPd7TveP5iyJE0EjAuZQTgFLD2ylzuqKfdKlfG/eSrtxUkn" crossorigin="anonymous">
            <title>Saleems Takeaway</title>
        
            <link href="https://fonts.googleapis.com/css2?family=Comfortaa:wght@300;400;500;600;700&family=Poppins:wght@200;400;500&display=swap" rel="stylesheet">
        
            <style>
                body {
                    font-family: Poppins;
                    background: #efefef;
                }
                
                h1 {
                    font-size: 35px;
                    line-height: 40px;
                    height: auto;
                    color: rgb(58, 58, 58);
                    font-weight: 500;
                    position: relative;
                    margin-bottom: 40px;
                }
                
                p {
                    color: #141414;
                    font-size: 14px;
                    margin-bottom: 10px;
                }
                
                h2 {
                    color: #000000;
                    font-size: 21px;
                    text-transform: uppercase;
                    letter-spacing: 2px;
                }
                /* .invoiceHeader {
                    border-bottom: 2px dashed #efefef;
                } */
                
                .border-bottom {
                    border-bottom: 2px dashed #efefef !important;
                }
                
                p span {
                    font-weight: 400;
                    color: #000;
                    font-weight: 500;
                    letter-spacing: 0;
                }
                
                p:last-child {
                    margin-bottom: 0 !important;
                }
                
                .ItemInfo p span {
                    font-size: 16px;
                }
            </style>
        </head>
        
        <body>
            <div class="container py-5  col-xl-9">
                <div class="container-inner rounded col-sm-8 mx-auto bg-white pb-2 px-0">
                    <div class="invoiceHeader border-bottom px-5 py-3">
                        <p class="d-flex">
                            <strong>Store Name:</strong>
                            <span class="d-block mr-0 ml-auto text-right">Saleems Takeawa</span>
                        </p>
                        <p class="d-flex">
                            <strong class="pr-2">Store Address:</strong>
                            <span class="d-block mr-0 ml-auto text-right">365 Bloor Street East, <br>Toronto, Ontario, M4W 3L4, Canada</span>
                        </p>
                    </div>
                    <div class="CustomInfo border-bottom px-5 py-3">
                        <p class="d-flex">
                            <strong class="pr-2">Order Number:  </strong> <span class="d-block mr-0 ml-auto text-right">#109</span>
                        </p>
                        <p class="d-flex mb-0">
                            <strong class="pr-2">Date & Time </strong>
                            <span class="d-block mr-0 ml-auto text-right">2022-04-24 17:18:37</span>
                        </p>
                    </div>
        
                    <div class="ItemInfo border-bottom px-5 py-3">
                        <p class="d-flex">
                            <strong class="pr-2">1 x Small Donner</strong>
                            <span class="d-block mr-0 ml-auto text-right ">6</span>
                        </p>
                        <p class="d-flex">
                            <strong class="pr-2">1 x Large Donner</strong>
                            <span class="d-block mr-0 ml-auto text-right">6.5</span>
                        </p>
                        <p class="d-flex mb-0">
                            <strong class="pr-2">1 x King Size Donner</strong>
                            <span class="d-block mr-0 ml-auto text-right">7.5</span>
                        </p>
                    </div>
        
                    <div class="ItemInfo border-bottom px-5 py-3">
                        <p class="d-flex">
                            <strong class="pr-2">Sub total</strong>
                            <span class="d-block mr-0 ml-auto text-right ">20</span>
                        </p>
                        <p class="d-flex">
                            <strong class="pr-2">Taxes</strong>
                            <span class="d-block mr-0 ml-auto text-right">4</span>
                        </p>
                        <p class="d-flex">
                            <strong class="pr-2">Delivery Fee</strong>
                            <span class="d-block mr-0 ml-auto text-right">0</span>
                        </p>
                        <p class="d-flex">
                            <strong class="pr-2">Discount</strong>
                            <span class="d-block mr-0 ml-auto text-right">0</span>
                        </p>
                        <p class="d-flex mb-0">
                            <strong class="pr-2" style="font-size: 20px;">Total</strong>
                            <span class="d-block mr-0 ml-auto text-right">24</span>
                        </p>
                    </div>
        
                    <div class="Customer border-bottom px-5 py-3">
                        <p class="d-flex">
                            <strong class="pr-2">Customer Name:</strong>
                            <span class="d-block mr-0 ml-auto text-right">Rohini</span>
                        </p>
                        <p class="d-flex mb-0">
                            <strong class="pr-2">Customer Mobile:</strong>
                            <span class="d-block mr-0 ml-auto text-right">08008102265</span>
                        </p>
                    </div>
        
                    <div class="Customer border-bottom px-5 py-4">
                        <h2 class="m-0 text-center">Thank you for ordering with us</h2>
                    </div>
                </div>
            </div>
        </body>
        
        </html>';
    }

    private function printLine($title, $price)
    {
        $rightCols = 10;
        $leftCols = 38;

        $left = str_pad($title, $leftCols);

        $right = str_pad($price, $rightCols, ' ', STR_PAD_LEFT);
        return "$left$right\n";
    }
}
