<?php

namespace Vtlabs\Ecommerce\Jobs;

use Illuminate\Bus\Queueable;
use Vtlabs\Ecommerce\Models\Order;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Log;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Vtlabs\Core\Models\PushNotification;
use Vtlabs\Core\Services\FirebaseService;
use Vtlabs\Appointment\Models\Appointment;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Vtlabs\Core\Helpers\PushNotificationHelper;
use Vtlabs\Ecommerce\Http\Resources\OrderResource;
use Vtlabs\Ecommerce\Http\Resources\AppointmentResource;

class FirebaseUpdateAppointment implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private $appointmentId;

    /**
     * Create a new job instance.
     *
     * @param  PushNotification  $pushNotification
     * @return void
     */
    public function __construct($appointmentId)
    {
        $this->appointmentId = $appointmentId;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        try {
            $firebaseDatabase = FirebaseService::getDatabaseInstance();
            if ($firebaseDatabase) {
                $appointment = new AppointmentResource(Appointment::find($this->appointmentId));
                $firebaseDatabase->getReference('/appointments/' . $appointment->id . "/data")->set($appointment);

                if ($appointment->appointer_id) {
                    $firebaseDatabase->getReference('/users/' . $appointment->appointer_id . '/appointments/' . $appointment->id . "/data")->set($appointment);
                }

                if ($appointment->appointee_id) {
                    $firebaseDatabase->getReference('/vendors/' .  $appointment->appointee_id . '/appointments/' . $appointment->id . "/data")->set($appointment);
                }
            }
        } catch (\Exception $ex) {
            Log::error($ex);
        }
    }
}