<?php

namespace Vtlabs\Ecommerce\Jobs;

use Carbon\Carbon;
use Illuminate\Bus\Queueable;
use Vtlabs\Ecommerce\Models\Order;
use Illuminate\Support\Facades\Log;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Vtlabs\Core\Models\PushNotification;
use Vtlabs\Core\Services\FirebaseService;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Vtlabs\Ecommerce\Services\OrderService;
use Vtlabs\Ecommerce\Http\Resources\OrderResource;

class DeliverScheduledOrders implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @param  PushNotification  $pushNotification
     * @return void
     */
    public function __construct()
    {
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        try {
            Log::info("running DeliverScheduledOrders job");
            $orders = Order::where('type', 'LATER')
                ->where('scheduled_on', '<', Carbon::now()->format('Y-m-d H:i:s'))
                ->doesntHave('delivery')->get();
            Log::info(sprintf("%d orders found", count($orders)));
            foreach($orders as $order) {
                $orderService = new OrderService($order);
                $orderService->sendDeliveryRequest();
            }
        } catch (\Exception $ex) {
            //
        }
    }
}
