<?php

namespace Vtlabs\Ecommerce\Console\Commands;

use Illuminate\Console\Command;
use Vtlabs\Ecommerce\Models\Order;
use Illuminate\Support\Facades\Artisan;
use Vtlabs\Ecommerce\Services\PrintOrderService;

class Printer extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'ecommerce:printer {--orderid=*}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Vtlabs laravel print order';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        try {
            // validate database connection
            $orderid = $this->option('orderid')[0];

            $order = Order::find($orderid);
            if ($order) {
                $printerService = new PrintOrderService($order);
                $printerService->printEscpos();
            } else {
                echo "order not found";
            }
        } catch (\Exception $ex) {
            $this->error($ex->getMessage());
            return 1;
        }

        return 0;
    }
}
