<?php

namespace Vtlabs\Ecommerce\Models;

use EloquentFilter\Filterable;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
use Vtlabs\Core\Traits\CoreHasMediaTrait;
use Spatie\MediaLibrary\HasMedia\HasMedia;

class DeliveryProfile extends Model implements HasMedia
{
    use Filterable,
        CoreHasMediaTrait;
    
    protected $table = 'ecommerce_delivery_profiles';
    
    protected $guarded = [];
    
    protected $casts = [
        'meta' => 'json',
        'is_verified' => 'integer',
        'is_online' => 'integer',
        'assigned' => 'integer',
        'longitude' => 'float',
        'latitude' => 'float'
    ];

    protected $appends = ['mediaurls'];

    protected static function booted()
    {
        // static::updated(function ($deliveryProfile) {
        //     if($deliveryProfile->isDirty('is_online')) {
        //         DB::table('ecommerce_delivery_online_log')->insert([
        //             'is_online' => $deliveryProfile->is_online,
        //             'delivery_profile_id' => $deliveryProfile->id
        //         ]);
        //     } 
        // });
    }

    public static function findByUser($userId)
    {
        return DeliveryProfile::where('user_id', $userId)->firstOrFail();
    }

    public function user()
    {
        return $this->belongsTo(config('auth.models.user'));
    }
}
