<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDeliveryProfilesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ecommerce_delivery_profiles', function (Blueprint $table) {
            $table->increments('id');
            $table->json('meta')->nullable();
            $table->boolean('is_verified')->default(true);
            $table->boolean('is_online')->default(false);
            $table->boolean('assigned')->default(false);
            $table->decimal('longitude', 15, 7)->nullable();
            $table->decimal('latitude', 15, 7)->nullable();
            $table->timestamps();

            $table->integer('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
        });

        Schema::create('ecommerce_delivery_online_log', function (Blueprint $table) {
            $table->increments('id');
            $table->boolean('is_online');
            $table->integer('delivery_profile_id')->unsigned()->nullable();
            $table->foreign('delivery_profile_id')->references('id')->on('ecommerce_delivery_profiles')->onDelete('cascade');
            $table->timestamps();
        });

        Schema::create('ecommerce_delivery_panic_log', function (Blueprint $table) {
            $table->increments('id');
            $table->string('text');
            $table->integer('delivery_profile_id')->unsigned()->nullable();
            $table->foreign('delivery_profile_id')->references('id')->on('ecommerce_delivery_profiles')->onDelete('cascade');
            $table->timestamps();
        });
        
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ecommerce_delivery_online_log', function (Blueprint $table) {
            $table->dropForeign(['delivery_profile_id']);
        });
        Schema::dropIfExists('ecommerce_delivery_online_log');

        Schema::table('ecommerce_delivery_panic_log', function (Blueprint $table) {
            $table->dropForeign(['delivery_profile_id']);
        });
        Schema::dropIfExists('ecommerce_delivery_panic_log');

        Schema::table('ecommerce_delivery_profiles', function (Blueprint $table) {
            $table->dropForeign(['user_id']);
        });
        Schema::dropIfExists('ecommerce_delivery_profiles');
    }
}
