<?php

namespace Vtlabs\Ecommerce\Listeners;

use Vtlabs\Core\Models\User\User;
use Vtlabs\Ecommerce\Models\Vendor;
use Vtlabs\Ecommerce\Events\UpdateAppointment;

class UpdateAppointmentListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  UpdateAppointment $event
     * @return void
     */
    public function handle(UpdateAppointment $event)
    {
        $vendor = Vendor::find($event->appointment->appointee_id);
        $user = User::find($event->appointment->appointer_id);

        if ($user) {
            if (in_array($event->appointment->status, ['accepted', 'complete', 'rejected'])) {
                $user->sendPushNotification(
                    'customer',
                    __('vtlabs_ecommerce::messages.notification_update_appointment_title', ['id' => $event->appointment->id, 'status' => $event->appointment->status]),
                    __('vtlabs_ecommerce::messages.notification_update_appointment_body')
                );
            }
        }

        if ($vendor) {
            if (in_array($event->appointment->status, ['cancelled', 'complete'])) {
                $vendor->user->sendPushNotification(
                    'vendor',
                    __('vtlabs_ecommerce::messages.notification_update_appointment_title', ['id' => $event->appointment->id, 'status' => $event->appointment->status]),
                    __('vtlabs_ecommerce::messages.notification_update_appointment_body')
                );
            }
        }

        return true;
    }
}
