<?php

namespace Vtlabs\Ecommerce\Listeners;

use Vtlabs\Ecommerce\Models\Vendor;
use Vtlabs\Core\Events\RoleAssigned;
use Vtlabs\Ecommerce\Events\NewAppointment;

class NewAppointmentListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  RoleAssigned $event
     * @return void
     */
    public function handle(NewAppointment $event)
    {
        $vendor = Vendor::find($event->appointment->appointee_id);

        $vendor->user->sendPushNotification(
            'vendor',
            __('vtlabs_ecommerce::messages.notification_new_appointment_vendor_title', ['id' => $event->appointment->id]),
            __('vtlabs_ecommerce::messages.notification_new_appointment_vendor_body')
        );

        return true;
    }
}
