<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVendorAvailabilitiesTable extends Migration
{
    public function up()
    {
        Schema::create('ecommerce_vendor_availabilities', function (Blueprint $table) {
            $table->increments('id');
            $table->enum('days', ['sun', 'mon', 'tue', 'wed', 'thu', 'fri', 'sat']);
            $table->time('from');
            $table->time('to');
            $table->integer('vendor_id')->unsigned();
            $table->foreign('vendor_id')->references('id')->on('ecommerce_vendors')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ecommerce_vendor_availabilities', function (Blueprint $table) {
            $table->dropForeign(['vendor_id']);
        });
        Schema::dropIfExists('ecommerce_vendor_availabilities');
    }
}
