<?php

namespace Vtlabs\Ecommerce\Services;

use Illuminate\Support\Facades\Log;

class SmsService
{
    public function send($mobileNumber, $message, $backup = false)
    {
        // send sms
        try {
            $token = env('SMS_TOKEN');
            $sender = env('SMS_SENDER');

            if (!$token || !$sender) {
                throw new \Exception('SMS sending not configured properly');
            }

            $params = array(
                'to'            => $mobileNumber,           //destination number  
                'from'          => $sender,                  //sendername made in https://ssl.smsapi.com/sms_settings/sendernames
                'message'       => $message,                //message content
                'format'        => 'json',
            );

            if ($backup == true) {
                $url = 'https://api2.smsapi.com/sms.do';
            } else {
                $url = 'https://api.smsapi.com/sms.do';
            }

            $c = curl_init();
            curl_setopt($c, CURLOPT_URL, $url);
            curl_setopt($c, CURLOPT_POST, true);
            curl_setopt($c, CURLOPT_POSTFIELDS, $params);
            curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($c, CURLOPT_HTTPHEADER, array(
                "Authorization: Bearer $token"
            ));

            $content = curl_exec($c);
            $http_status = curl_getinfo($c, CURLINFO_HTTP_CODE);

            if ($http_status != 200 && $backup == false) {
                $backup = true;
                $this->send($params, $token, $backup);
            }

            curl_close($c);
            return $content;
        } catch (\Exception $ex) {
            Log::error($ex->getMessage());
        }
    }
}
