<?php

namespace Vtlabs\Ecommerce\Services;

use Carbon\Carbon;
use Mike42\Escpos\Printer;
use Mike42\Escpos\EscposImage;
use Vtlabs\Ecommerce\Models\Order;
use Vtlabs\Core\Helpers\CoreHelper;
use Mike42\Escpos\PrintConnectors\FilePrintConnector;

class item
{
    private $name;
    private $price;
    private $dollarSign;

    public function __construct($name = '', $price = '', $dollarSign = false)
    {
        $this->name = $name;
        $this->price = $price;
        $this->dollarSign = $dollarSign;
    }

    public function __toString()
    {
        $rightCols = 10;
        $leftCols = 38;
        if ($this->dollarSign) {
            $leftCols = $leftCols / 2 - $rightCols / 2;
        }
        $left = str_pad($this->name, $leftCols);

        $sign = ($this->dollarSign ? '$ ' : '');
        $right = str_pad($sign . $this->price, $rightCols, ' ', STR_PAD_LEFT);
        return "$left$right\n";
    }
}

class PrintOrderService
{
    private $order;

    public function __construct(Order $order)
    {
        $this->order = $order;
    }

    public function printEscpos()
    {
        /* Start the printer */
        $path = tempnam(sys_get_temp_dir(), 'prefix');
        $connector = new FilePrintConnector($path);
        $printer = new Printer($connector);

        /* Name of shop */
        //$printer->selectPrintMode(Printer::MODE_DOUBLE_WIDTH | Printer::MODE_DOUBLE_HEIGHT);
        //$printer->selectPrintMode(Printer::MODE_EMPHASIZED | Printer::MODE_DOUBLE_HEIGHT | Printer::MODE_DOUBLE_HEIGHT);
        //$printer -> selectPrintMode(Printer::MODE_EMPHASIZED);
        //$printer -> setTextSize(4, 4);

        $printer->setEmphasis(true);
        $printer->setJustification(Printer::JUSTIFY_CENTER);
        $printer->text(strtoupper($this->greeklish(env('PRINT_NAME'))));
        $printer->setJustification(Printer::JUSTIFY_LEFT);
        //$printer->feed();
        //$printer -> setTextSize(3, 3);
        // $printer->selectPrintMode(Printer::MODE_DOUBLE_WIDTH);
        //$printer->text(strtoupper($this->greeklish(env('PRINT_ADDRESS'))));
        //$printer->feed();
        // $printer -> setTextSize(2, 2);
        //$printer->text(strtoupper($this->greeklish(env('PRINT_PHONE'))));
        $printer->setEmphasis(false);
        $printer->selectPrintMode();
        //$printer->feed();

        // $logo = EscposImage::load(public_path('assets/vendor/product/receipt-logo.png'), false);
        // $printer -> graphics($logo);

        $printer->text("\n----------------------\n");
        //$printer->feed();

        /* date and order id */
        $orderType = '';
        if ($this->order->order_type = Order::ORDER_TYPE_NORMAL) {
            $orderType = 'Delivery';
        }

        if ($this->order->order_type = Order::ORDER_TYPE_TAKEAWAY) {
            $orderType = 'Takeaway';
        }

        if ($this->order->order_type = Order::ORDER_TYPE_DINEIN) {
            $orderType = 'Dinein';
        }

        if ($this->order->order_type = Order::ORDER_TYPE_CUSTOM) {
            $orderType = 'Custom';
        }

        $printer->setEmphasis(true);
        $printer->text('Payment - '. strtoupper($this->order->payment->paymentMethod->title));
        $printer->setEmphasis(false);
        $printer->feed();
        $printer->text($this->greeklish('Order number: ' . $this->order->id));
        $printer->feed();
        $printer->text($this->order->created_at);
        //$printer->feed();

        $printer->text("\n----------------------\n");
        //$printer->feed();

        /* Items */
        //$printer -> setJustification(Printer::JUSTIFY_LEFT);
        //$printer -> setEmphasis(true);
        //$printer -> text(new item('', '$'));
        //$printer -> setEmphasis(false);
        foreach ($this->order->products as $product) {
            $printer->text($this->printLine($product->quantity . ' x ' . substr($product->vendorProduct->product->title, 0, 40), $product->total));

            foreach ($product->addonChoices as $choice) {
                $printer->text($this->printLine('  ' . substr($choice->addonChoice->title, 0, 40), ''));
            }
        }
        $printer->feed();
        //$printer -> setEmphasis(true);
        $printer->text($this->printLine('Subtotal', $this->order->subtotal));
        //$printer -> setEmphasis(false);
        //$printer->feed();

        /* Tax and total */
        $printer->text($this->printLine('Taxes', $this->order->taxes));
        //$printer->feed();

        $printer->text($this->printLine('Delivery Fee', $this->order->delivery_fee));
        //$printer->feed();

        $printer->text($this->printLine('Discount', $this->order->discount));
        //$printer->feed();

        //$printer -> selectPrintMode(Printer::MODE_DOUBLE_WIDTH);
        $printer->setEmphasis(true);
        $printer->text($this->printLine('Total', $this->order->total));
        $printer->setEmphasis(false);
        //$printer->feed();
        //$printer->selectPrintMode();

        /* Footer */
        //$printer->feed();
        //$printer->feed();
        //$printer->setJustification(Printer::JUSTIFY_CENTER);

        if ($this->order->user) {
            $printer->text("\n----------------------\n");
            $printer->text("Customer Details:\n");
            $printer->text("ID:" . $this->order->user->id . " \n");
            $printer->text("Name:" . $this->greeklish($this->order->user->name) . " \n");
            $printer->text("Mobile:" . $this->order->user->mobile_number . " \n");
            if($this->order->address && $this->order->address->formatted_address) {
                $printer->text("Addr:" . $this->greeklish($this->order->address->formatted_address) . " \n");
            }
            $printer->feed();
        } else if ($this->order->customer_name) {
            $printer->text("\n----------------------\n");
            $printer->text("Customer Details:\n");
            $printer->text("Customer Name:" . $this->order->customer_name . " \n");
            $printer->text("Customer Mobile:" . $this->order->customer_mobile . " \n");
        }

        $printer->feed(2);

        /* Cut the receipt and open the cash drawer */
        //$printer->cut();
        //$printer->pulse();

        $printer->close();
        
        return file_get_contents($path);
    }

    private function printLine($title, $price)
    {
        $rightCols = 10;
        $leftCols = 14;
        
        $title = $this->greeklish($title);

        $left = str_pad($title, $leftCols);

        $right = str_pad($price, $rightCols, ' ', STR_PAD_LEFT);
        return "$left$right\n";
    }
    
    private function greeklish($new_text){
        $new_text = mb_convert_encoding($new_text, "UTF-8", mb_detect_encoding($new_text));

        $greek_len   = array('α','ά','Ά','Α','β','Β','γ', 'Γ', 'δ','Δ','ε','έ','Ε','Έ','ζ','Ζ','η','ή','Η','θ','Θ','ι','ί','ϊ','ΐ','Ι','Ί', 'κ','Κ','λ','Λ','μ','Μ','ν','Ν','ξ','Ξ','ο','ό','Ο','Ό','π','Π','ρ','Ρ','σ','ς', 'Σ','τ','Τ','υ','ύ','Υ','Ύ','φ','Φ','χ','Χ','ψ','Ψ','ω','ώ','Ω','Ώ',' ',"'","'",',');

        $english_len = array('a', 'a','A','A','b','B','g','G','d','D','e','e','E','E','z','Z','i','i','I','th','Th', 'i','i','i','i','I','I','k','K','l','L','m','M','n','N','x','X','o','o','O','O','p','P' ,'r','R','s','s','S','t','T','u','u','Y','Y','f','F','ch','Ch','ps','Ps','o','o','O','O',' ','',' ',' ');
        $new_text  = str_replace($greek_len,$english_len,$new_text);
        return $new_text;
    }
}

