<?php

namespace Vtlabs\Ecommerce\Listeners;

use Vtlabs\Ecommerce\Models\Order;
use Illuminate\Support\Facades\Log;
use Vtlabs\Ecommerce\Events\NewOrder;
use Vtlabs\Ecommerce\Services\OrderService;
use Vtlabs\Ecommerce\Services\SmsService;

class NewOrderListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  NewOrder $event
     * @return void
     */
    public function handle(NewOrder $event)
    {
        $order = $event->order;

        if(!in_array($order->status, Order::ACTIVE_ORDER_STATUS)) {
            // check if order is actually new, in somecase e.g cash payment we are marking payment as paid when order completes, and this listener is called when
            // ever payment status is set to paid, this should be rightfully handled in payment listener but for now we are fixing it here
            return;
        }

        $orderService = new OrderService($order);

        // only send delivery request if order is deliverable
        if (in_array($order->order_type, Order::DELIVERABLE_ORDER_TYPES)) {
            if (!$order->vendor) {
                // only send delivery request if this order is non vendor, in case of vendor related order
                // we wait for vendor to accept the order
                $orderService->sendDeliveryRequest();
            }
        }

        $smsService = new SmsService();
        $smsService->send(
            $order->vendor->user->mobile_number,
            sprintf(
                'ΝΕΑ ΠΑΡΑΓΓΕΛΙΑ!\nID #%s',
                $order->id
            )
        );

        $orderService->notifyFirebase();

        if ($order->vendor) {
            $order->vendor->user->sendPushNotification(
                'vendor',
                __('vtlabs_ecommerce::messages.notification_new_order_vendor_title', ['id' => $order->id]),
                __('vtlabs_ecommerce::messages.notification_new_order_vendor_body')
            );
        }
    }
}
