<?php

namespace Vtlabs\Ecommerce\Listeners;

use Carbon\Carbon;
use Vtlabs\Core\Models\User\User;
use Illuminate\Support\Facades\Log;
use Vtlabs\Ecommerce\Models\Vendor;
use Vtlabs\Core\Events\RoleAssigned;
use Vtlabs\Ecommerce\Events\NewAppointment;
use Vtlabs\Ecommerce\Services\SmsService;

class NewAppointmentListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  RoleAssigned $event
     * @return void
     */
    public function handle(NewAppointment $event)
    {
        $vendor = Vendor::find($event->appointment->appointee_id);

        if (!$event->appointment->is_guest) {
            $name = User::find($event->appointment->appointer_id)->name;
        } else {
            $name = $event->appointment->customer_name;
        }


        $smsService = new SmsService();
        $smsService->send(
            $vendor->user->mobile_number,
            sprintf(
                'Booking ID %s, %s,\n%s persons, %s',
                $event->appointment->id,
                $name,
                $event->appointment->meta['person'],
                Carbon::createFromFormat('Y-m-d', $event->appointment->date)->format('l, M j') . ' at ' .  $event->appointment->time_from
            )
        );

        $vendor->user->sendPushNotification(
            'vendor',
            __('vtlabs_ecommerce::messages.notification_new_appointment_vendor_title', ['id' => $event->appointment->id]),
            __('vtlabs_ecommerce::messages.notification_new_appointment_vendor_body')
        );

        return true;
    }
}
