<?php

namespace Vtlabs\Ecommerce\Console;

use Carbon\Carbon;
use Vtlabs\Ecommerce\Models\Order;
use Illuminate\Support\Facades\Log;
use Vtlabs\Ecommerce\Services\SmsService;
use Illuminate\Console\Scheduling\Schedule;
use Vtlabs\Ecommerce\Console\Commands\Printer;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        Printer::class
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        $schedule->call(function () {
            Log::info("Scheduled called");
            $smsService = new SmsService();
            $orders = Order::whereDate('created_at', Carbon::now()->format('Y-m-d'))->whereTime('created_at', '<', Carbon::now()->subMinutes(5)->format('H:i:s'))->currentStatus('new')->whereNull('meta->delay_sms_sent')->get();
            foreach ($orders as $order) {
                Log::info("Sending sms for id#" . $order->id);
                $smsService->send(
                    $order->vendor->user->mobile_number,
                    sprintf(
                        'ΥΠΕΝΘΎΜΙΣΗ ΜΗ ΔΙΕΥΘΕΤΗΜΕΝΗΣ ΠΑΡΑΓΓΕΛΙΑΣ ID #%s',
                        $order->id
                    )
                );
                $meta = $order->meta;
                $meta['delay_sms_sent'] = 1;
                $order->meta = $meta;
                $order->save();
            }
        })->everyMinute();
    }

    /**
     * Register the Closure based commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        require base_path('routes/console.php');
    }
}
