<?php

namespace Vtlabs\Core\Http\Requests\Api;

use Illuminate\Foundation\Http\FormRequest;

class LoginRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'token' => 'required_without:email',
            'role' => 'required',
            'email' => 'required_without:token|email',
            'password' => 'required_with:email'
        ];
    }
}
