<?php

namespace Vtlabs\Core\Http\Controllers\Api\Admin;

use Illuminate\Http\Request;
use Vtlabs\Core\Models\Setting;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Vtlabs\Core\Http\Controllers\Controller;
use Brotzka\DotenvEditor\DotenvEditor as Env;
use Brotzka\DotenvEditor\Exceptions\DotEnvException;
use Illuminate\Database\Eloquent\ModelNotFoundException;

class SettingController extends Controller
{
    public function index(Request $request)
    {
        $request->validate([
            'country_code' => 'sometimes'
        ]);

        $settings = Setting::query();
        if ($request->country_code) {
            if (Setting::where('country_code', $request->country_code)->exists()) {
                $settings = $settings->where('country_code', $request->country_code);
            } else {
                $settings = $settings->whereNull('country_code');
            }
        }

        return response()->json($settings->get());
    }

    public function update(Request $request)
    {
        $countryCode = $request->country_code ?? 'world';
        $inputs = $request->except(['country_code']);
        $create = false;

        if ($countryCode && $countryCode != 'world' && !Setting::where('country_code', $countryCode)->exists()) {
            $create = true;
        }

        foreach ($inputs as $key => $value) {
            try {
                if ($key != 'countries' && $create) {
                    DB::table('settings')->insert([[
                        'key' => $key,
                        'value' => $value,
                        'country_code' => $countryCode
                    ]]);
                } else {
                    if ($countryCode && $countryCode != 'world') {
                        $setting = Setting::where('key', $key)->where('country_code', $countryCode)->firstOrFail();
                    } else {
                        $setting = Setting::where('key', $key)->whereNull('country_code')->firstOrFail();
                    }

                    $setting->value = $value ?? '';
                    $setting->country_code = $countryCode != 'world' ? $countryCode : null;
                    $setting->save();
                }
            } catch (ModelNotFoundException $ex) {
                //
            }
        }

        return response()->json([]);
    }

    public function envList(Request $request)
    {
        $env = new Env();
        return response()->json($env->getContent());
    }

    /**
     * Update env variables.
     *
     * @param Request $request
     * @return mixed
     */
    public function updateEnv(Request $request)
    {
        $env = new Env();
        try {
            $env->changeEnv($request->all());
        } catch (DotEnvException $e) {
        }

        return response()->json([]);
    }
}
