<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name');
            $table->string('email')->unique()->nullable();
            $table->string('username')->unique()->nullable();
            $table->string('password');
            $table->string('mobile_number')->unique();
            $table->boolean('mobile_verified')->default(false);
            $table->boolean('is_verified')->default(false);
            $table->tinyInteger('active')->default(1)->unsigned();
            $table->string('language')->default('en');
            $table->json('notification')->nullable();
            $table->json('meta')->nullable();
            $table->integer('sub_users_count')->default(0);
            $table->boolean('mobile_verified')->default(false);
            $table->rememberToken();
            $table->timestamps();

            $table->text('postal_codes')->nullable();

            $table->boolean('is_city_admin')->default(false);

            $table->integer('parent_id')->unsigned()->nullable();
            $table->foreign('parent_id')->references('id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
