<?php

namespace Vtlabs\Core\Http\Requests\Api;

use Illuminate\Foundation\Http\FormRequest;

class RegisterRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required|max:255',
            'email' => 'sometimes|unique:users',
            'mobile_number' => 'required|unique:users',
            'image' => 'sometimes|url',
            'role' => ['required', 'role'],
            'meta' => 'sometimes'
        ];
    }
}
