<?php

namespace Vtlabs\Core\Http\Controllers\Api;

use DateTime;
use DateTimeZone;
use Illuminate\Http\Request;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Core\Helpers\Agora\RtcTokenBuilder;

class AgoraController extends Controller
{
    public function token(Request $request)
    {
        $request->validate([
            'channel' => 'required',
            'uid' => 'sometimes'
        ]);

        $appID = env('AGORA_APP_ID');
        $appCertificate = env('AGORA_APP_CERTIFICATE');
        $channelName = $request->channel;
        $uid = $request->uid;
        $uidStr = $request->uid;
        $role = RtcTokenBuilder::RoleAttendee;
        $expireTimeInSeconds = 90000;
        $currentTimestamp = (new DateTime("now", new DateTimeZone('UTC')))->getTimestamp();
        $privilegeExpiredTs = $currentTimestamp + $expireTimeInSeconds;
        
        // $token = RtcTokenBuilder::buildTokenWithUid($appID, $appCertificate, $channelName, $uid, $role, $privilegeExpiredTs);
        // echo 'Token with int uid: ' . $token . PHP_EOL;
        
        $token = RtcTokenBuilder::buildTokenWithUserAccount($appID, $appCertificate, $channelName, $uidStr, $role, $privilegeExpiredTs);
        //echo 'Token with user account: ' . $token . PHP_EOL;

        return response()->json(['token' => $token]);
    }
}
