<?php

namespace Vtlabs\Core\Services;

class GoogleDistanceService
{
    private $source_latitude, $source_longitude, $destination_latitude, $destination_longitude;

    public function __construct(
        $source_latitude,
        $source_longitude,
        $destination_latitude,
        $destination_longitude
    ) {
        $this->source_latitude = $source_latitude;
        $this->source_longitude = $source_longitude;
        $this->destination_latitude = $destination_latitude;
        $this->destination_longitude = $destination_longitude;
    }

    public function distanceAndTime()
    {
        try {
            $url = $this->buildGoogleDistanceUrl();

            $response = $this->fetch($url);
            if (!empty($response) && isset($response->distance)) {
                $distance = ceil($response->distance->value / 1000); // meters to km
                $time = ceil($response->duration->value / 60); // seconds to minutes
                return [$distance, $time];
            }
            throw new \Exception("Unable to calculate distance and time");
        } catch (\Exception $ex) {
            return [0, 0];
        }
    }

    private function buildGoogleDistanceUrl()
    {
        // url to get distance with traffic time, departure_time param is timestamp, when this param is passed api returns duration_in_traffic
        // https://maps.googleapis.com/maps/api/distancematrix/json?origins=26.163700074772592,91.75302136319644&destinations=26.12000493545194,91.83207697924462&key=AIzaSyBh4_7hE5aZZpRg2f0yEiW7VGrWgSYP1o8&departure_time=1749458008

        $googleKey = env('FIREBASE_KEY');
        
        if(!$googleKey) {
            throw new \Exception('Valid key not present');
        }

        $googleOrigin = $this->source_latitude . ',' . $this->source_longitude;
        $googleDestination = $this->destination_latitude . ',' . $this->destination_longitude;

        $url = 'https://maps.googleapis.com/maps/api/distancematrix/json?'
            . 'origins=' . $googleOrigin . '&destinations=' . $googleDestination . '&departure_time=' . time() . '&key=' . $googleKey;
        return $url;
    }

    private function fetch($googleUrl)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $googleUrl);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
        $response = json_decode(curl_exec($ch));
        curl_close($ch);

        try {
            return $response->rows[0]->elements[0];
        } catch (\Exception $ex) {
            return [];
        }
    }
}
